#define Version 100     //Version 1.00
#define _SUPPRESS_PLIB_WARNING                                      // required for XC1.33  Later compiler versions will need PLIB to be installed
#include <plib.h>                                                   // the pre Harmony peripheral libraries
#include "CFunctions.h"
#define AVG_DC_SAVED     0
#define WHICH_ADC_INPUT  1
#define AVG_DC_LEVEL     2
#define VOLTS_SSUM1      3
#define VOLTS_SSUM2      4
#define VOLTS_NUM        5
#define AMPS_SSUM1       6
#define AMPS_SSUM2       7
#define AMPS_NUM         8
#define AMPS_SUM         9
#define AMPS_SUM_NUM    10
#define LAST_VOLTS      11
#define VA_SSUM1        12
#define VA_SSUM2        13
#define VA_NUM          14
#define W_SSUM1         15
#define W_SSUM2         16
#define W_NUM           17
#define AMP_CALIBRATION 18
#define ZEROCROSS_SENSE 19
//#define ZEROCROSS_TIMER 20
#define ZEROCROSS_COUNT 21
#define VOLTS_ACCUM1    22
#define VOLTS_ACCUM2    23
#define AMPS_ACCUM1     24
#define AMPS_ACCUM2     25
#define VA_ACCUM1       26
#define VA_ACCUM2       27
#define W_ACCUM1        28
#define W_ACCUM2        29
#define ACCUM_NUM       30
#define DC_AVG_DELAY    31

#define DC_AVG_SCALE_INIT 8
#define DC_AVG_SCALE_DELAY (1<<(DC_AVG_SCALE_INIT+2))
#define DC_AVG_SCALE 14
#define DEFAULT_PERIOD 14

void AccumulateLongLong(signed long long* ptr, signed long long* val) {
    *ptr += *val;
    *val = 0;
}

static unsigned short readADC(unsigned short xmit) {
    unsigned int recv, clocks;

    // transmit: SD OS S1 S0 COM UNI SLP
    // VOLTS      1  0  0  0  1   0   0
    // AMPS       1  0  1  0  1   0   0
    LATBCLR = 1<<13;
    LATBCLR = (1<<10)|(1<<11);
    recv = 0;
    clocks = 16;

    do {
        if( xmit & 0x8000 )
            LATASET = 1<<2;
        else
            LATACLR = 1<<2;

        recv = (recv<<1) | PORTAbits.RA3;

        LATBSET = 1<<13;

        xmit <<= 1;

        LATBCLR = 1<<13;
    } while( --clocks );

    LATBSET = (1<<10)|(1<<11);
    return recv;
}

void T1Int(void) {
    unsigned int which = CFuncRam[WHICH_ADC_INPUT];
    int avg_DC_saved = CFuncRam[AVG_DC_SAVED];
    signed short val = readADC( (which == 0) ? 0xA9FF : 0x89FF );

    if( which == 0 ) {
        int avg_DC_level = CFuncRam[AVG_DC_LEVEL];
        if( CFuncRam[DC_AVG_DELAY] ) {
            avg_DC_level = avg_DC_level - (avg_DC_level >> DC_AVG_SCALE_INIT) + val;
            if( --CFuncRam[DC_AVG_DELAY] == 0 )
                avg_DC_level <<= (DC_AVG_SCALE - DC_AVG_SCALE_INIT);
            CFuncRam[AVG_DC_LEVEL] = avg_DC_level;
        } else {
            avg_DC_level = avg_DC_level - (avg_DC_level >> DC_AVG_SCALE) + val;
            CFuncRam[AVG_DC_LEVEL] = avg_DC_level;
        }
    }
    val -= avg_DC_saved;
    if( which == 0 ) {
        *((signed long long*)&CFuncRam[VOLTS_SSUM1]) += (signed long)val * (signed long)val;
        ++CFuncRam[VOLTS_NUM];
        CFuncRam[LAST_VOLTS] = val;

        if( ((*((int*)&CFuncRam[ZEROCROSS_SENSE]) < 0) != (val < 0) || CFuncRam[VOLTS_NUM] > 1000) && CFuncRam[VOLTS_NUM] > 36 ) {
//            if( ++CFuncRam[ZEROCROSS_TIMER] == 24 ) {
                if( val >= 0 || CFuncRam[VOLTS_NUM] > 1000 )
                    CFuncRam[AVG_DC_SAVED] = CFuncRam[AVG_DC_LEVEL] >> (CFuncRam[DC_AVG_DELAY] ? DC_AVG_SCALE_INIT : DC_AVG_SCALE);
                CFuncRam[ZEROCROSS_SENSE] = (int)val;
//                CFuncRam[ZEROCROSS_TIMER] = 0;
                ++CFuncRam[ZEROCROSS_COUNT];

                AccumulateLongLong(((signed long long*)&CFuncRam[VOLTS_ACCUM1]), ((signed long long*)&CFuncRam[VOLTS_SSUM1]));
//                *((signed long long*)&CFuncRam[VOLTS_ACCUM1]) += *((signed long long*)&CFuncRam[VOLTS_SSUM1]);
//                *((signed long long*)&CFuncRam[VOLTS_SSUM1]) = 0;
                AccumulateLongLong(((signed long long*)&CFuncRam[AMPS_ACCUM1]), ((signed long long*)&CFuncRam[AMPS_SSUM1]));
//                *((signed long long*)&CFuncRam[AMPS_ACCUM1]) += *((signed long long*)&CFuncRam[AMPS_SSUM1]);
//                *((signed long long*)&CFuncRam[AMPS_SSUM1]) = 0;
                AccumulateLongLong(((signed long long*)&CFuncRam[VA_ACCUM1]), ((signed long long*)&CFuncRam[VA_SSUM1]));
//                *((signed long long*)&CFuncRam[VA_ACCUM1]) += *((signed long long*)&CFuncRam[VA_SSUM1]);
//                *((signed long long*)&CFuncRam[VA_SSUM1]) = 0;
                AccumulateLongLong(((signed long long*)&CFuncRam[W_ACCUM1]), ((signed long long*)&CFuncRam[W_SSUM1]));
//                *((signed long long*)&CFuncRam[W_ACCUM1]) += *((signed long long*)&CFuncRam[W_SSUM1]);
//                *((signed long long*)&CFuncRam[W_SSUM1]) = 0;
                CFuncRam[ACCUM_NUM] += CFuncRam[VOLTS_NUM];
                CFuncRam[VOLTS_NUM] = 0;
                CFuncRam[AMPS_NUM] = 0;
                CFuncRam[VA_NUM] = 0;
                CFuncRam[W_NUM] = 0;
//            }
//        } else {
//            CFuncRam[ZEROCROSS_TIMER] = 0;
        }
    } else {
        signed short last_volts = CFuncRam[LAST_VOLTS];
        signed long va_val;//, w_fact = 1;
        val += *((long int*)&CFuncRam[AMP_CALIBRATION]);
        *((signed long long*)&CFuncRam[AMPS_SSUM1]) += (signed long)val * (signed long)val;
        ++CFuncRam[AMPS_NUM];
        *((int*)&CFuncRam[AMPS_SUM]) += val;
        ++CFuncRam[AMPS_SUM_NUM];
/*
        if( last_volts < 0 ) {
            last_volts = -last_volts;
            w_fact = -1;
        }
        if( val < 0 ) {
            val = -val;
            w_fact = -w_fact;
        }
*/
        va_val = (signed long)last_volts * (signed long)val;
        if( va_val > 0 )
            *((signed long long*)&CFuncRam[VA_SSUM1]) += va_val;
        else
            *((signed long long*)&CFuncRam[W_SSUM1]) -= va_val;
//        if( w_fact > 0 )
//            *((signed long long*)&CFuncRam[W_SSUM1]) -= va_val;
//        else
//            *((signed long long*)&CFuncRam[W_SSUM1]) += va_val;
        ++CFuncRam[VA_NUM];
        ++CFuncRam[W_NUM];
    }

    CFuncRam[WHICH_ADC_INPUT] = 1 - which;
//    PR1 = (which == 1 ? TMR1 + 2 : DEFAULT_PERIOD);
}

__attribute__((noinline)) void getFPC(void *a, void *b, volatile unsigned int *c) 
     { 
         *c = (unsigned int) (__builtin_return_address (0) - (b -a)) ;      
     } 

long long int main(int* function, long long int* reading, long long int* reading2, long long int* reading3, long long int* reading4, long long int* reading5){
    if( *function == 1 ) { // initialise
        volatile unsigned int libAddr ;
        getFPC(NULL,&&getFPCLab,&libAddr) ; // warning can be ignored, stupid editor
        getFPCLab: { }

        mT1IntEnable(0);
        CFuncRam[AMP_CALIBRATION] = reading ? *((long int*)reading) : 0;
        CFuncRam[WHICH_ADC_INPUT] = 1;
        CFuncRam[AVG_DC_LEVEL] = 0;
        CFuncRam[AVG_DC_SAVED] = 0;
        *((signed long long*)&CFuncRam[VOLTS_SSUM1]) = 0;
        CFuncRam[VOLTS_NUM] = 0;
        *((signed long long*)&CFuncRam[AMPS_SSUM1]) = 0;
        CFuncRam[AMPS_NUM] = 0;
        CFuncRam[AMPS_SUM] = 0;
        CFuncRam[AMPS_SUM_NUM] = 0;
        *((signed long long*)&CFuncRam[VA_SSUM1]) = 0;
        CFuncRam[VA_NUM] = 0;
        *((signed long long*)&CFuncRam[W_SSUM1]) = 0;
        CFuncRam[W_NUM] = 0;
        CFuncRam[ZEROCROSS_SENSE] = 0;
//        CFuncRam[ZEROCROSS_TIMER] = 0;
        CFuncRam[ZEROCROSS_COUNT] = 0;
        CFuncRam[DC_AVG_DELAY] = DC_AVG_SCALE_DELAY;
        CFuncT1=(unsigned int)&T1Int + libAddr;
        T1CON = 0x8030;
        PR1 = DEFAULT_PERIOD;
        mT1SetIntPriority(1);
        mT1ClearIntFlag();
        mT1IntEnable(1);
/*
    } else if( *function == 2 ) { // read RMS voltage & reset voltage measurement

        int ret;
        mT1IntEnable(0);
        *reading = *((signed long long*)&CFuncRam[VOLTS_SSUM1]);
        ret = CFuncRam[VOLTS_NUM];
        *((signed long long*)&CFuncRam[VOLTS_SSUM1]) = 0;
        CFuncRam[VOLTS_NUM] = 0;
        mT1IntEnable(1);
        return (long long int)ret;
    } else if( *function == 3 ) { // read RMS current & reset current measurement
        int ret;
        mT1IntEnable(0);
        *reading = *((signed long long*)&CFuncRam[AMPS_SSUM1]);
        ret = CFuncRam[AMPS_NUM];
        *((signed long long*)&CFuncRam[AMPS_SSUM1]) = 0;
        CFuncRam[AMPS_NUM] = 0;
        mT1IntEnable(1);
        return (long long int)ret;
    } else if( *function == 4 ) { // read VA figure & reset current measurement
        int ret;
        mT1IntEnable(0);
        *reading = *((signed long long*)&CFuncRam[VA_SSUM1]);
        ret = CFuncRam[VA_NUM];
        *((signed long long*)&CFuncRam[VA_SSUM1]) = 0;
        CFuncRam[VA_NUM] = 0;
        mT1IntEnable(1);
        return (long long int)ret;
    } else if( *function == 5 ) { // read W figure & reset current measurement
        int ret;
        mT1IntEnable(0);
        *reading = *((signed long long*)&CFuncRam[W_SSUM1]);
        ret = CFuncRam[W_NUM];
        *((signed long long*)&CFuncRam[W_SSUM1]) = 0;
        CFuncRam[W_NUM] = 0;
        mT1IntEnable(1);
        return (long long int)ret;
*/
    } else if( *function == 6 ) { // read average current & reset measurement
        int ret;
        mT1IntEnable(0);
        *reading = (long long int)*((int*)&CFuncRam[AMPS_SUM]);
        ret = CFuncRam[AMPS_SUM_NUM];
        CFuncRam[AMPS_SUM] = 0;
        CFuncRam[AMPS_SUM_NUM] = 0;
        mT1IntEnable(1);
        return (long long int)ret;
/*
    } else if( *function == 7 ) { // read & reset zero cross counter
        int ret;
        mT1IntEnable(0);
        ret = CFuncRam[ZEROCROSS_COUNT];
        CFuncRam[ZEROCROSS_COUNT] = 0;
        mT1IntEnable(1);
        return (long long int)ret;
*/
    } else if( *function == 8 ) { // read & reset accumulated data (accumulated over integer multiple of zero crossings)
        int ret;
        mT1IntEnable(0);
        ret = CFuncRam[ZEROCROSS_COUNT];
        *reading = *((signed long long*)&CFuncRam[VOLTS_ACCUM1]);
        *((signed long long*)&CFuncRam[VOLTS_ACCUM1]) = 0;
        *reading2 = *((signed long long*)&CFuncRam[AMPS_ACCUM1]);
        *((signed long long*)&CFuncRam[AMPS_ACCUM1]) = 0;
        *reading3 = *((signed long long*)&CFuncRam[VA_ACCUM1]);
        *((signed long long*)&CFuncRam[VA_ACCUM1]) = 0;
        *reading4 = *((signed long long*)&CFuncRam[W_ACCUM1]);
        *((signed long long*)&CFuncRam[W_ACCUM1]) = 0;
        *reading5 = (signed long long)CFuncRam[ACCUM_NUM];
        CFuncRam[ACCUM_NUM] = 0;
        CFuncRam[ZEROCROSS_COUNT] = 0;
        mT1IntEnable(1);
        return (long long int)ret;
    } else if( *function == 9 ) { // read average DC level
        return (long long int) *((int*)&CFuncRam[AVG_DC_SAVED]);
    } else if( *function == 10 ) { // calibrate amps
        CFuncRam[AMP_CALIBRATION] = reading ? *((long int*)reading) : 0;
    } else if( *function == 11 ) { // set average DC level
        mT1IntEnable(0);
        CFuncRam[DC_AVG_DELAY] = 0;
        CFuncRam[AVG_DC_LEVEL] = *reading << DC_AVG_SCALE;
        mT1IntEnable(1);
        return *reading;
    }
    return 0;
 }
